// SetWorkspace.cpp

#include "SetWorkspace.h"

int main( int argc, char **argv )
{
	SetWorkspaceApp	myApp;
	
	myApp.Run();
	
	exit( 0 );
}

SetWorkspaceApp::SetWorkspaceApp()
	: BApplication( "application/x-working-setworkspace" )
{
	return;
}

SetWorkspaceApp::~SetWorkspaceApp()
{
	return;
}

void SetWorkspaceApp::ArgvReceived(int32 argc, char **argv)
{
	if ( argc != 2 ){
		Usage();
		PostMessage( B_QUIT_REQUESTED );
		return;
	}
	
	int n = atoi( argv[ 1 ] );
	
	if ( n < 1 || n > count_workspaces() ){
		Usage();
		PostMessage( B_QUIT_REQUESTED );
		return;
	}

	snooze( 100000 );				// 1.0.1 work around deskbar bug
	
	activate_workspace( n - 1 );
	
	PostMessage( B_QUIT_REQUESTED );
	return;
}

	
void SetWorkspaceApp::Usage()
{
	fprintf( stderr, "setworkspace 1.0d1 by Michael D. Crawford crawford@scruznet.com\n" );
	fprintf( stderr, "http://www.scruznet.com/~crawford/\n" );
	fprintf( stderr, "Usage: setworkspace n, where n is a workspace number from 1 through 9\n" );
	return;
}